local RAIL 	= 0
local CATAPULT = 1

local function BD3(clsid)
	return {CLSID = clsid, arg_value = 0.15 }
end

local function MBD(clsid)
	return {CLSID = clsid, arg_value = 0.25 }
end

Su_47K =  {
	Name = 'Su-47K',
	DisplayName	= _('Su-47K Berkut'),
    EmptyWeight = "16375", --11300 - unusable fuel 78kg 
	MaxFuelWeight = "10000",
	MaxHeight = "18000",
	MaxSpeed = "2230",
	MaxTakeOffWeight = "34000",
	Picture = "Su-47K.png",
	Rate = "50",
	Shape = "Su-47K",
	WingSpan = 15.16,
    WorldID = WSTYPE_PLACEHOLDER,

	HumanCockpit 		= true,
	HumanCockpitPath    = current_mod_path..'/Cockpit/Scripts/',

	shape_table_data 	= 
	{
		{
			file  	 	= 'Su-47K'; --AG --edm file name
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'Su-47K-oblomok'; -- Name of destroyed object edm name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'Su-47K';
			index    	=  WSTYPE_PLACEHOLDER;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
		{
			name  		= "Su-47K-oblomok";
			file  		= "Su-47K-oblomok"; --edm name
			fire  		= { 240, 2};
		},
	},
		
	mapclasskey = "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Multirole fighters", "Refuelable", "Datalink"},
	Categories			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	-------------------------	
		-- Basic stats --
	-------------------------
	--Weight
	    M_empty = 16375, --11000 - unusable fuel 78kg 
		M_nominal	=	22000,
		M_max	=	34000,
		M_fuel_max	=	10000,

		H_max	=	18000, --height
		average_fuel_consumption	=	0.2743,
		CAS_min	=	1.58, --min speed that is shwon in hud
		V_opt	=	185, --cruisespeed
		V_take_off	=	70, --takeoff speed
		V_land	=	65, --landing speed
		has_afteburner	=	true,
		has_speedbrake	=	true,
		radar_can_see_ground	=	true,

		AOA_take_off	=	0.17, -- AoA in take off (for AI)
		stores_number	=	12,
		bank_angle_max	=	60, -- Max bank angle (for AI)
		Ny_min	=	-3, -- Min G (for AI)
		Ny_max	=	12, -- Max G (for AI)
		tand_gear_max	=	0.577, --XX  1.732 FA18 3.73,
		V_max_sea_level	=	1618, -- Max speed at sea level in m/s (for AI)
		V_max_h	=	2230, -- Max speed at max altitude in m/s (for AI)
		tanker_type	=	4,  --
		wing_area	=	61.87, -- wing area in m2, important for FM
		wing_span	=	15.16,
		wing_type = 2, -- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		thrust_sum_max	=	19005, -- thrust in kgf not kN
		thrust_sum_ab	=	31012, -- thrust in kgf not kN
		Vy_max	=	330, -- Max climb speed in m/s (for AI)
		length	=	22.60,
		height	=	6.30,
		flaps_maneuver	=	1,
		Mach_max	=	1.87, -- Max speed in Mach (for AI)
		range	=	3300, -- Max range in km (for AI)
		RCS	=	0.3, -- Radar Cross Section m2
		Ny_max_e	=	12, -- Max G (for AI)
		detection_range_max	=	250,
		IR_emission_coeff	=	0.77, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab	=	3, -- With afterburner
		engines_count	=	2,
		wing_tip_pos = 	{-1.6,	0.75,	7}, 
		--------------------------------------
	         -- SUSPENSION CODE BEGINS --
	    --------------------------------------
		nose_gear_pos 								= {5.75, -1.949, 0},
		nose_gear_amortizer_direct_stroke			= 0,  -- down from nose_gear_pos !!!
		nose_gear_amortizer_reversal_stroke			= 1.517 - 1.794,  -- up 
		nose_gear_amortizer_normal_weight_stroke	= -0.07,-- down from nose_gear_pos
		nose_gear_wheel_diameter					=	0.84,
		--nose_gear_door_close_after_retract			=	false,

		main_gear_pos 							 = {-2.8,-1.8,	1.75},    --{-0.928,-1.789,	1.523},
		main_gear_amortizer_direct_stroke		 = 0, --  down from main_gear_pos !!!
		main_gear_amortizer_reversal_stroke		 = 1.395 - 1.689, --  up 
		main_gear_amortizer_normal_weight_stroke = -0.1,-- down from main_gear_pos
		main_gear_wheel_diameter				 =	0.84,
		--nose_gear_door_close_after_retract			=	false,

		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-8.5,	0.69,	-0.675},
				elevation	=	0, --vertical rotation in degree
				diameter	=	0.949,
				exhaust_length_ab	=	8.629,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
				azimuth      = 0, -- horizontal rotation in degree
			}, -- end of [1]
			[2] = 
			{
				pos = 	{-8.5,	0.69, 0.645},
				elevation	=	0, --vertical rotation in degree
				diameter	=	0.949,
				exhaust_length_ab	=	8.629,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
				azimuth      = 0, -- horizontal rotation in degree
			}, -- end of [2]
		}, -- end of engines_nozzles
		crew_memb1ers = 
		{
			[1] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	48,
				pos = 	{4.403,	1.209,	0},
			}, -- end of [1]
		}, -- end of crew_members
		
		crew_members = 
		{
			[1] = 
			{
					ejection_seat_name	=	9,
					drop_canopy_name	=	48,
					pos = 	{4.403,	1.209,	0},
					ejection_order 		= 2,
					canopy_arg          = 38, 
					pilot_body_arg 		= 540,
					can_be_playable 	= true,
					ejection_added_speed = {-5,15,0},
					role 				 = "pilot",
					role_display_name    = _("Pilot"),
					--ejection_through_canopy = true, --no openbeta usare mechanimations
			
				g_suit 			   =  2.2,
				bailout_arg = -1, --abilitare su openbeta con mechanimations
			}, -- end of [1]
		}, -- end of crew_members
		
		brakeshute_name	=	4,
		air_refuel_receptacle_pos 	= 	{8.15,	1.58,	-1.15},-- refuel coords -- {+Forward|-Backwards, +UP|-Down, -Left|+Right} {7.8658,	1.05078,	-0.7762}
		
		fires_pos = 
		{
			[1] = 	{-1.36,	-0.185,	0},
			[2] = 	{-0.595,	0.294,	2.66},
			[3] = 	{-1.743,	0.234,	-3.769},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{-4.471,	-0.059,	0.91},
			[9] = 	{-4.471,	-0.059,	-0.91},
			[10] = 	{-0.491,	0.629,	2.03},
			[11] = 	{-0.491,	-0.019,	0},
		}, -- end of fires_pos
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0,	0.999,	0.052},
				pos = 	{-0.937,	1.645,	-1.726},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0,	0.999,	-0.052},
				pos = 	{-0.937,	1.645,	1.726},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser
	--    mechanimations openbeta ok
	passivCounterm = {
			CMDS_Edit = true,
			SingleChargeTotal = 96,
			-- PPR-26
			chaff = {default = 48, increment = 12, chargeSz = 1},
			-- PPI-26
			flare = {default = 48, increment = 12, chargeSz = 1}
        },
        
    mechanimations = {
          Door0 = {
                {Transition = {"Close", "Open"},  Sequence = {
                        {C = {{"Arg", 38, "to", 0.12 * 0.9, "at", 0.6, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.25 * 0.9, "at", 1.0, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.75 * 0.9, "at", 0.3, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.85 * 0.9, "at", 1.0, "sign" , 1}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.5}}},
                         }, Flags = {"Reversible"}},
                {Transition = {"Open", "Close"},  Sequence = {
                        {C = {{"Arg", 38, "to", 0.00 * 0.9, "at", 0.6}}},
                        {C = {{"Arg", 38, "to", 0.12 * 0.9, "at", 1.0, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.25 * 0.9, "at", 0.3, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.75 * 0.9, "at", 1.0, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.85 * 0.9, "at", 0.5, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.90 * 0.9, "at", 0.25, "sign" , -1}}},
                        {C = {{"Arg", 38, "to", 0.95 * 0.9, "at", 0.125, "sign" , -1}}},
                         }, Flags = {"Reversible", "StepsBackwards"}},
                {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0}}}}},
            },
			FoldableWings = {
				{Transition = {"Retract", "Extend"}, Sequence = {
							{C = {{"Arg", 8, "to", 0.0, "in", 5.0}}},
						}, Flags = {"Reversible"}},
				{Transition = {"Extend", "Retract"}, Sequence = {
							{C = {{"Arg", 8, "to", 1.0, "in", 5.0}}},
						}, Flags = {"Reversible", "StepsBackwards"}},
			},
        },

		

	-- add model draw args for network transmitting to this draw_args table (16 limit)
	net_animation = 
	{
          8, -- Fold wings
		 13, -- right LE flap
		 14, -- left LE flap
		 19, -- Right Canard
		 20, -- Left Canard 
		 21, -- Airbrake
		 23, -- Wheel Chock
		 24, -- Intake closer
		 25, -- hoook
		 26, -- Bomb bay doors
		 35, -- drag chute
		 36, -- drag chute
		 37, -- drag chute
	    181, --	Canopy Ext
		190,
		191,
		192,
		274, -- left aux inlet
		275, -- right aux inlet
		327, -- left up gun door
		328, -- right up gun door
		329, 
		350,
		351,
		419, -- right down gun door
		427, -- right down gun door
		470, -- nose strut
		450, -- nose strut
	   2215, -- right thrust v
	   2216, -- left thrust v
	   3322,
	   3480,
	   3481,
	   3482,
	   2016,
	   2015,
	},
	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_AVERAGE, LOOK_AVERAGE, LOOK_AVERAGE),
	EPLRS = true,
	Sensors = {
		RADAR =  "AN/APG-63"  ,
		IRST  = "OLS-27",
		RWR   = "Abstract RWR",
	},
	Countermeasures = {
	ECM 			= "AN/ALQ-165",
	},	
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			--{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio	= {
		frequency	= 124.0,
		editable	= true,
		minFrequency	= 118.000,
		maxFrequency	= 399.975,
	    rangeFrequency = {
			{min = 118.0, max = 155.995},
			{min = 225.0, max = 399.975}
		},
		modulation	= MODULATION_AM,
	},
	panelRadio	= {
		[1] = {  
		    name = _("COMM 1: R-800"),
		    range = {
				{min = 30.0, max = 87.995},
				{min = 108.0, max = 173.995},
				{min = 225.0, max = 399.975}
			},
			channels = {
				[1] = { name = _("Channel 1"),		default = 305.0, modulation = _("AM/FM"), connect = true}, -- default
				[2] = { name = _("Channel 2"),		default = 264.0, modulation = _("AM/FM")},	-- min. water : 135.0, 264.0
				[3] = { name = _("Channel 3"),		default = 265.0, modulation = _("AM/FM")},	-- nalchik : 136.0, 265.0
				[4] = { name = _("Channel 4"),		default = 256.0, modulation = _("AM/FM")},	-- sochi : 127.0, 256.0
				[5] = { name = _("Channel 5"),		default = 254.0, modulation = _("AM/FM")},	-- maykop : 125.0, 254.0
				[6] = { name = _("Channel 6"),		default = 250.0, modulation = _("AM/FM")},	-- anapa : 121.0, 250.0
				[7] = { name = _("Channel 7"),		default = 270.0, modulation = _("AM/FM")},	-- beslan : 141.0, 270.0
				[8] = { name = _("Channel 8"),		default = 257.0, modulation = _("AM/FM")},	-- krasnodar-pashk. : 128.0, 257.0
				[9] = { name = _("Channel 9"),		default = 255.0, modulation = _("AM/FM")},	-- gelenjik : 126.0, 255.0
				[10] = { name = _("Channel 10"),	default = 262.0, modulation = _("AM/FM")},	-- kabuleti : 133.0, 262.0
				[11] = { name = _("Channel 11"),	default = 259.0, modulation = _("AM/FM")},	-- gudauta : 130.0, 259.0
				[12] = { name = _("Channel 12"),	default = 268.0, modulation = _("AM/FM")},	-- soginlug : 139.0, 268.0
				[13] = { name = _("Channel 13"),	default = 269.0, modulation = _("AM/FM")},	-- vaziani : 140.0, 269.0
				[14] = { name = _("Channel 14"),	default = 260.0, modulation = _("AM/FM")},	-- batumi : 131.0, 260.0
				[15] = { name = _("Channel 15"),	default = 263.0, modulation = _("AM/FM")},	-- kutaisi : 134.0, 263.0
				[16] = { name = _("Channel 16"),	default = 261.0, modulation = _("AM/FM")},	-- senaki : 132.0, 261.0
				[17] = { name = _("Channel 17"),	default = 267.0, modulation = _("AM/FM")},	-- lochini : 138.0, 267.0
				[18] = { name = _("Channel 18"),	default = 251.0, modulation = _("AM/FM")},	-- krasnodar-center : 122.0, 251.0
				[19] = { name = _("Channel 19"),	default = 253.0, modulation = _("AM/FM")},	-- krymsk : 124.0, 253.0
				[20] = { name = _("Channel 20"),	default = 266.0, modulation = _("AM/FM")},	-- mozdok : 137.0, 266.0
			}
		},
		[2] = {  
		    name = _("COMM 2: R-800"),
		    range = {
				{min = 30.0, max = 87.995},
				{min = 108.0, max = 173.995},
				{min = 225.0, max = 399.975}
			},
			channels = {
				[1] = { name = _("Channel 1"),		default = 305.0, modulation = _("AM/FM"), connect = true}, -- default
				[2] = { name = _("Channel 2"),		default = 264.0, modulation = _("AM/FM")},	-- min. water : 135.0, 264.0
				[3] = { name = _("Channel 3"),		default = 265.0, modulation = _("AM/FM")},	-- nalchik : 136.0, 265.0
				[4] = { name = _("Channel 4"),		default = 256.0, modulation = _("AM/FM")},	-- sochi : 127.0, 256.0
				[5] = { name = _("Channel 5"),		default = 254.0, modulation = _("AM/FM")},	-- maykop : 125.0, 254.0
				[6] = { name = _("Channel 6"),		default = 250.0, modulation = _("AM/FM")},	-- anapa : 121.0, 250.0
				[7] = { name = _("Channel 7"),		default = 270.0, modulation = _("AM/FM")},	-- beslan : 141.0, 270.0
				[8] = { name = _("Channel 8"),		default = 257.0, modulation = _("AM/FM")},	-- krasnodar-pashk. : 128.0, 257.0
				[9] = { name = _("Channel 9"),		default = 255.0, modulation = _("AM/FM")},	-- gelenjik : 126.0, 255.0
				[10] = { name = _("Channel 10"),	default = 262.0, modulation = _("AM/FM")},	-- kabuleti : 133.0, 262.0
				[11] = { name = _("Channel 11"),	default = 259.0, modulation = _("AM/FM")},	-- gudauta : 130.0, 259.0
				[12] = { name = _("Channel 12"),	default = 268.0, modulation = _("AM/FM")},	-- soginlug : 139.0, 268.0
				[13] = { name = _("Channel 13"),	default = 269.0, modulation = _("AM/FM")},	-- vaziani : 140.0, 269.0
				[14] = { name = _("Channel 14"),	default = 260.0, modulation = _("AM/FM")},	-- batumi : 131.0, 260.0
				[15] = { name = _("Channel 15"),	default = 263.0, modulation = _("AM/FM")},	-- kutaisi : 134.0, 263.0
				[16] = { name = _("Channel 16"),	default = 261.0, modulation = _("AM/FM")},	-- senaki : 132.0, 261.0
				[17] = { name = _("Channel 17"),	default = 267.0, modulation = _("AM/FM")},	-- lochini : 138.0, 267.0
				[18] = { name = _("Channel 18"),	default = 251.0, modulation = _("AM/FM")},	-- krasnodar-center : 122.0, 251.0
				[19] = { name = _("Channel 19"),	default = 253.0, modulation = _("AM/FM")},	-- krymsk : 124.0, 253.0
				[20] = { name = _("Channel 20"),	default = 266.0, modulation = _("AM/FM")},	-- mozdok : 137.0, 266.0
			}
		},
	},
	TACAN_AA	= true,
	Guns = {gun_mount("GSh_30_1", { count = 150 },{muzzle_pos = {3.7,   1.3,  -1.18}}),
	},

--	pylons_enumeration = {12, 1, 11, 2, 3, 10, 4, 9, 5, 8, 7, 6}
--  Types: 0=direct,1=delayed, 2=invisibl
	Pylons =     {     
		pylon(1, 0, -6.8, 0.7, -1.86, { DisplayName = "ECM" }, --ECM on the back
            {
                { CLSID = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}" ,},--Sorbciya ECM
            }
        ),                             
		pylon(2, 0, -1.5, 0.65, -6.7, --pylon 1 outside
            {
				DisplayName = "1",
				arg = 214,
				arg_value = 0, 
				FiZ = -1,
				connector = "Pylon2",
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
                 --IR--
				{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",  attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M
			    { CLSID = "{Su30-R-73L-AA}",arg_value = 1, },  --R-73L
                { CLSID = "{Su30-R-73M-AA}",arg_value = 1,},--R-73M
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",arg_value = 1,}, --R-73
				--Smoke--
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
			
        ),
        pylon(3, 0, -1.8, 0.55, -5.72, --pylon 2 outside
            {
				DisplayName = "2",
				arg = 213 ,
				arg_value = 0, 
				FiZ = -1,
				connector = "Pylon3",
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
				--Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 1,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M

                --IR Fox 2--
			    --{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M
			    { CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                { CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 1, arg_value = 1, },	--R-27ET

				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" ,attach_point_position = {-0.5, 0, 0}, Type = 1, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 1, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 1 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE

				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
			
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
        pylon(4, 0,  -2.3, 0.55, -4.3, --pylon 3 outside
            {
				DisplayName = "3",
				arg = 212 ,
				arg_value = 0, 
				FiZ = -1,
				connector = "Pylon4",
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
                --Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 1,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M
			    --{ CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                --{ CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                -- { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 1, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" ,attach_point_position = {-0.5, 0, 0}, Type = 1, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 1, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 1 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
		pylon(5,  1,-0.8, 0.45, -0.6975, --pylon 1 inside
            {
				DisplayName = "4",
			    arg_value = 1, 
				FiZ = -1, --clean be default
				use_full_connector_position = true, --if you have connectors in the edm
            },    
		    {
			
                { CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", attach_point_position = {1, 0, 0}},--BetAB-500
                { CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}", attach_point_position = {1, 0, 0}},--BetAB-500ShP
                { CLSID = '{37DCC01E-9E02-432F-B61D-10C166CA2798}', attach_point_position = {1, 0, 0}}, --FAB-500 M62
                { CLSID = '{3C612111-C7AD-476E-8A8E-2485812F4E5C}', attach_point_position = {1, 0, 0}},--FAB-250
				{ CLSID = "{FAB_250_M62}", attach_point_position = {1, 0, 0}},							--FAB-250 M62
                { CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", attach_point_position = {1, 0, 0}},--RBK-250 PTAB-2.5M
                { CLSID = "{RBK_250_275_AO_1SCH}", attach_point_position = {1, 0, 0}},                -- RBK-250-275 AO-1SCh
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", attach_point_position = {1, 0, 0}},--RBK-500 PTAB-10-5
                { CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", attach_point_position = {1, 0, 0}},--RBK-500 PTAB-1M
                { CLSID = "{RBK_500U_OAB_2_5RT}", attach_point_position = {1, 0, 0}},                --RBK-500U OAB-2.5RT
			
                --Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 1 ,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,Type = 1}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,Type = 1},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    -- { CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                -- { CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                -- { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 1, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" , Type = 1, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 1, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 1 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
        pylon(6, 1,-0.8, 0.45, -0.36, --pylon 2 inside
		    {
			   DisplayName = "5",
			   arg_value = 1, 
			   FiZ = -1, --clean be default
			   use_full_connector_position = true, --if you have connectors in the edm
            },
            {
                { CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", attach_point_position = {1, 0, 0}},--BetAB-500
                { CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}", attach_point_position = {1, 0, 0}},--BetAB-500ShP
                { CLSID = '{37DCC01E-9E02-432F-B61D-10C166CA2798}', attach_point_position = {1, 0, 0}}, --FAB-500 M62
                { CLSID = '{3C612111-C7AD-476E-8A8E-2485812F4E5C}', attach_point_position = {1, 0, 0}},--FAB-250
				{ CLSID = "{FAB_250_M62}", attach_point_position = {1, 0, 0}},							--FAB-250 M62
                { CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", attach_point_position = {1, 0, 0}},--RBK-250 PTAB-2.5M
                { CLSID = "{RBK_250_275_AO_1SCH}", attach_point_position = {1, 0, 0}},                -- RBK-250-275 AO-1SCh
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", attach_point_position = {1, 0, 0}},--RBK-500 PTAB-10-5
                { CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", attach_point_position = {1, 0, 0}},--RBK-500 PTAB-1M
                { CLSID = "{RBK_500U_OAB_2_5RT}", attach_point_position = {1, 0, 0}},                --RBK-500U OAB-2.5RT
                --Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 1,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    --{ CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                --{ CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                --{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				--{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 1, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" , Type = 1, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 1, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 1 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
	    ),
        pylon(7,  1, 2.85, 0.45, -0.22, --pylon 3 inside
		    {
				arg = 26 ,
				DisplayName = "6",
		        arg_value = 1, 
				FiZ = -1, --clean be default
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
                --IR--
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    { CLSID = "{Su30-R-73L-AA}",arg_value = 1, },  --R-73L
                { CLSID = "{Su30-R-73M-AA}",arg_value = 1,},--R-73M
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",arg_value = 1,}, --R-73
                --Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
		pylon(8, 1, 2.85, 0.45, 0.148, --pylon 4 inside
		    {
				DisplayName = "7",
			    arg_value = 1, 
				FiZ = -1, --clean be default
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
				--IR--
				{ CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    { CLSID = "{Su30-R-73L-AA}",arg_value = 1, },  --R-73L
				{ CLSID = "{Su30-R-73M-AA}",arg_value = 1,},--R-73M
				{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",arg_value = 1,}, --R-73
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
				
            }
	    ),
		pylon(9,  1,-0.8, 0.45, 0.284, --pylon 5 inside
		    {
				DisplayName = "8",
			    arg_value = 1, 
				FiZ = -1, --clean be default
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
                { CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", attach_point_position = {1, 0, 0}},--BetAB-500
                { CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}", attach_point_position = {1, 0, 0}},--BetAB-500ShP
                { CLSID = '{37DCC01E-9E02-432F-B61D-10C166CA2798}', attach_point_position = {1, 0, 0}}, --FAB-500 M62
                { CLSID = '{3C612111-C7AD-476E-8A8E-2485812F4E5C}', attach_point_position = {1, 0, 0}},--FAB-250
				{ CLSID = "{FAB_250_M62}", attach_point_position = {1, 0, 0}},							--FAB-250 M62
                { CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", attach_point_position = {1, 0, 0}},--RBK-250 PTAB-2.5M
                { CLSID = "{RBK_250_275_AO_1SCH}", attach_point_position = {1, 0, 0}},                -- RBK-250-275 AO-1SCh
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", attach_point_position = {1, 0, 0}},--RBK-500 PTAB-10-5
                { CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", attach_point_position = {1, 0, 0}},--RBK-500 PTAB-1M
                { CLSID = "{RBK_500U_OAB_2_5RT}", attach_point_position = {1, 0, 0}},                --RBK-500U OAB-2.5RT
				--Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 1,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    --{ CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                --{ CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                --{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				--{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 1, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" , Type = 1, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 1, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 1 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
	    ),
		pylon(10,  1,-0.8, 0.45, 0.64, --pylon 6 inside
		    {
				DisplayName = "9",
			    arg_value = 1, 
				FiZ = -1, --clean be default
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
                { CLSID = "{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", attach_point_position = {1, 0, 0}},--BetAB-500
                { CLSID = "{BD289E34-DF84-4C5E-9220-4B14C346E79D}", attach_point_position = {1, 0, 0}},--BetAB-500ShP
                { CLSID = '{37DCC01E-9E02-432F-B61D-10C166CA2798}', attach_point_position = {1, 0, 0}}, --FAB-500 M62
                { CLSID = '{3C612111-C7AD-476E-8A8E-2485812F4E5C}', attach_point_position = {1, 0, 0}},--FAB-250
				{ CLSID = "{FAB_250_M62}", attach_point_position = {1, 0, 0}},							--FAB-250 M62
                { CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", attach_point_position = {1, 0, 0}},--RBK-250 PTAB-2.5M
                { CLSID = "{RBK_250_275_AO_1SCH}", attach_point_position = {1, 0, 0}},                -- RBK-250-275 AO-1SCh
                { CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", attach_point_position = {1, 0, 0}},--RBK-500 PTAB-10-5
                { CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", attach_point_position = {1, 0, 0}},--RBK-500 PTAB-1M
                { CLSID = "{RBK_500U_OAB_2_5RT}", attach_point_position = {1, 0, 0}},                --RBK-500U OAB-2.5RT
				--Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 1,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    --{ CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                --{ CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                --{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 1, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" , Type = 1, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 1, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 1 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
	    ),
        pylon(11, 0, -2.3, 0.55, 4.2, --pylon 4 outside
            {
				DisplayName = "10",
				arg = 211 ,
				arg_value = 0, 
				FiZ = -1,
				connector = "Pylon11",
			    use_full_connector_position = true, --if you have connectors in the edm
            },
            {
				--Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 1,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                 --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    --{ CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                --{ CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                --{ CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 1, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" ,attach_point_position = {-0.5, 0, 0}, Type = 1, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 1, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 1 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
		 pylon(12, 0,  -1.8, 0.55, 5.65, --pylon 5 outside
            {
				DisplayName = "11",
				arg = 210,
				arg_value = 0, 
				FiZ = -1,
				connector = "Pylon12",
				use_full_connector_position = true, --if you have connectors in the edm
            },
            {
				--Radar Fox 3--
				{ CLSID = "{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}" , Type = 1,arg_value = 1,}, 	--R-77
                { CLSID = "{SU30_R771}", Type = 1,arg_value = 1,}, --R-77-1
                { CLSID = "{SU30_R77M}", Type = 1,arg_value = 1,},--R-77M
                --IR Fox 2--
				--{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0},arg_value = 1,},-- R-60M 
			    { CLSID = "{Su30-R-73L-AA}", arg_value = 1, },  --R-73L
                { CLSID = "{Su30-R-73M-AA}", arg_value = 1,},--R-73M
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 1,}, --R-73
				{ CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", Type = 1, arg_value = 1, },	--R-27ET
				--Radar Fox 1--
				{ CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}" ,attach_point_position = {-0.5, 0, 0}, Type = 1, arg_value = 1,},	--R-27R
                { CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}" , Type = 1, arg_value = 1,},	--R-27T
                { CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}", Type = 1 ,arg_value = 1,},	--R-27ER
                { CLSID = "{SU30_R27EA}", arg_value = 1,}, --R-27AE
				--Fuel Tank--
				--{CLSID = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", arg_value = 1,},-- Fuel tank 800L Wing
				--{ CLSID = "{PTB_800_MIG21}" , arg_value = 1,},--fuel tank
				
				--Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ),
        pylon(13, 0, -1.5, 0.65, 6.65, --pylon 6 outside
		    {
				DisplayName = "12",
			    arg = 209 ,
				arg_value = 0, 
				FiZ = -1,
				connector = "Pylon13",
			    use_full_connector_position = true, --if you have connectors in the edm
		    },
            {
			     --IR--
				{CLSID = "{682A481F-0CB5-4693-A382-D00DD4A156D7}", attach_point_position = {0.5, 0, 0}, arg_value = 1,},-- R-60M 
			    { CLSID = "{Su30-R-73L-AA}",arg_value = 1, },  --R-73L
                { CLSID = "{Su30-R-73M-AA}",arg_value = 1,},--R-73M
                { CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",arg_value = 1,}, --R-73
                 --Smoke--
				{ CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", arg_value = 1, },	--Smoke Generator - red
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", arg_value = 1, },	--Smoke Generator - green
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", arg_value = 1, },	--Smoke Generator - blue
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", arg_value = 1, },	--Smoke Generator - white
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", arg_value = 1, },	--Smoke Generator - yellow
                { CLSID = "{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", arg_value = 1, },	--Smoke Generator - orange
            }
        ), 
		pylon(14, 0, -7.3, 0.7, 1.5, { DisplayName = "ECM" }, --ECM in the Back
            {
                { CLSID = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}" ,},--Sorbciya ECM
            }
        ),
		       
},
	
	Tasks = {
        aircraft_task(AFAC),
        aircraft_task(SEAD),
        aircraft_task(AntishipStrike),
        aircraft_task(CAS),
        aircraft_task(PinpointStrike),
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
		aircraft_task(CAP),
     	aircraft_task(Escort),
        aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
	    aircraft_task(RunwayAttack),
    },	
	DefaultTask = aircraft_task(CAS),

-- M   - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B2 - Polar 2nd power coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)

			SFM_Data = { --Aerodynamics-----------SU-57 Airfoil main wing profile NACA64a204,SU-57 Airfoil horizontal wing profile NACA64a202,SU-57 Airfoil fin profile NACA64a003.
	aerodynamics =                                                       ---Development Improvements---
		{
			Cy0	      = 0,  --0.2    0,original -- zero AoA lift coefficient*
			Mzalfa	  =	4.355,         -- coefficients for pitch agility
			Mzalfadt  = 0.50, --0.50  -- coefficients for pitch agility
			kjx     = 2.75,     --2.75    -- Inertia parametre X - Dimension (clean) airframe drag coefficient at X (Top) Simply the wing area in square meters (as that is a major factor in drag calculations)
			kjz     = 0.00125,            -- Inertia parametre Z - Dimension (clean) airframe drag coefficient at Z (Front) Simply the wing area in square meters (as that is a major factor in drag calculations)
			Czbe    = -0.190,            -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear = 0.0268,         -- coefficient, drag, gear ??
			cx_flap = 0.05,           -- coefficient, drag, full flaps
			cy_flap = 0.52, --0.90    -- coefficient, normal force, lift, flaps
			cx_brk  = 0.08,            -- coefficient, drag, breaks
			
			table_data =
			{
			--    M	     Cx0		 Cya		 B		      B4	    Omxmax	Aldop	Cymax
				{0.0,	0.0150,		0.100,		0.1,		0.032,		3.65,	35.0,	1.6,	},
				{0.1,	0.0155,		0.087,		0.1,		0.032,		2.65,	35.0,	1.6,	},
				{0.2,	0.0160,		0.057,		0.1,		0.032,		3.95,	35.0,	1.6,	},
				{0.3,	0.0160,		0.055,		0.1,		0.032,		3.95,	35.0,	1.6,	},
				{0.4,	0.0160,		0.053,		0.1,	   	0.032,		3.25,	35.0,	1.6,	},
				{0.5,	0.0160,		0.052,		0.1,	   	0.032,		3.25,	35.0,	1.6,	},
				{0.6,	0.0165,		0.050,		0.094,		0.043,		4.55,	35.0,	1.6,	},
				{0.7,	0.0165,		0.049,		0.094,		0.045,		4.55,	35.0,	1.45,	},
				{0.8,	0.0178,		0.048,		0.094,		0.048,		4.55,	35.0,	1.4,    },
				{0.9,	0.0215,		0.047,		0.11,		0.050,		4.55,	35.0,	1.3,    },
				{1.0,	0.0310,		0.046,		0.15,		0.065,		4.55,	38.0,	1.2,    },
				{1.1,	0.0422,		0.045,	   	0.15,		0.070,		4.10,	36.0,	1.1,	},
				{1.2,	0.0440,		0.044,	   	0.14,		0.080,		3.19,	37.0,	1.05,	},		
				{1.3,	0.0432,		0.043,	   	0.17,		0.096,		2.28,	35.0,	1.0,	},
				{1.4,	0.0432,		0.043,	   	0.17,		0.096,		2.28,	35.0,	1.0,	},
				{1.5,	0.0423,		0.042,	   	0.23,		0.09,		1.95,	33.0,	0.9,	},
				{1.6,	0.0423,		0.041,	   	0.23,		0.09,		1.95,	33.0,	0.9,	},
				{1.7,	0.0423,		0.040,	   	0.23,		0.09,		1.95,	33.0,	0.9,	},
				{1.8,	0.0416,		0.049,	   	0.23,		0.38,		1.17,	23.0,	0.7,	},
				{1.9,	0.0416,		0.049,	   	0.23,		0.38,		1.17,	23.0,	0.7,	},
				{2.0,	0.0416,		0.069,	   	0.08,		2.5,		1.04,	30.5,	0.55,	},
				{2.1,	0.0416,		0.069,	   	0.08,		2.5,		1.04,	30.5,	0.55,	},
				{2.2,	0.0416,		0.070,	   	0.16,		3.2,		0.91,	39.0,	0.4,	},
                {2.3,	0.0416,		0.070,	   	0.16,		3.2,		0.91,	39.0,	0.4,	},
				{2.4,	0.0416,		0.070,	   	0.16,		3.2,		0.91,	39.0,	0.4,	},
				{2.5,	0.0410,		0.070,		0.25,		4.5,		0.91,	39.0,	0.4,	},		
				--{3.9,	0.0395,		0.070,		0.35,		6.0,		0.8,	39.0,	0.4		},			
			}, -- end of table_data

		
		}, -- end of aerodynamics
		
		engine = ----------- (WIP),Second Stage Engine.
		{
			Nmg	=	67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			typeng	=	1,
			hMaxEng	=	60000,
			dcx_eng	=	0.0000,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	8000,
			dpdh_f	=	17000.0,
			table_data = {
			--   M		Pmax		 Pfor
					--{0,		150000,	200000},
				 	--{0.2,	200000,	200040},
				 	--{0.4,	205000,	205500},
				 	--{0.6,	300000,	305620},
				 	--{0.7,	300500,	300700},
				 	--{0.8,	300600,	300700},
				 	--{0.9,	400700,	400750},
				 	--{1,		400550,	400650},
				 	--{1.1,	401100,	401200},
				 	--{1.2,	401200,	401300},
				 	--{1.3,	401300,	401400},
				 	--{1.5,	401400,	401500},
				 	--{1.8,	401500,	401600},
				 	--{2,0,   401600,	402600},
				 	--{2.5,	401700, 430000},



			    {0.0,	126000,	185024},
				{0.2,	126000,	198744},
				{0.4,	126000,	208250},
				{0.6,	126000,	220892},
				{0.7,	124000,	226870},
				{0.8,	124000,	232887},
				{0.9,	222000,	350210},
				{1.0,	217000,	356102},
				{1.1,	213000,	365430},
				{1.2,	210000,	380300},
				{1.3,	202000,	398900},
				{1.5,	25000,	326000},
				{1.8,	45000,	450000},
				{2.0,	46000,	663000},
				{2.2,	47000,	684000},
				{2.5,	482000,	915000},
				


				 	
				},
		}, -- end of engine
	},
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	
	Damage = {
		[0]  = {critical_damage = 5,  args = {146}}, --146
		[1]  = {critical_damage = 3,  args = {296}},
		[2]  = {critical_damage = 3,  args = {297}},
		[3]  = {critical_damage = 8, args = {65}},
		[4]  = {critical_damage = 2,  args = {298}},
		[5]  = {critical_damage = 2,  args = {301}},
		[7]  = {critical_damage = 2,  args = {249}},
		[8]  = {critical_damage = 3,  args = {265}},
		[9]  = {critical_damage = 3,  args = {154}},
		[10] = {critical_damage = 3,  args = {153}},
		[11] = {critical_damage = 1,  args = {167}},
		[12] = {critical_damage = 1,  args = {161}},
		[13] = {critical_damage = 2,  args = {169}},
		[14] = {critical_damage = 2,  args = {163}},
		[15] = {critical_damage = 2,  args = {267}},
		[16] = {critical_damage = 2,  args = {266}},
		[17] = {critical_damage = 2,  args = {168}},
		[18] = {critical_damage = 2,  args = {162}},
		[20] = {critical_damage = 2,  args = {183}},
		[23] = {critical_damage = 5, args = {223}},
		[24] = {critical_damage = 5, args = {213}},
		[25] = {critical_damage = 2,  args = {226}},
		[26] = {critical_damage = 2,  args = {216}},
		[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
		[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
		[35] = {critical_damage = 6, args = {225}, deps_cells = {23, 29, 25, 37}},
		[36] = {critical_damage = 6, args = {215}, deps_cells = {24, 30, 26, 38}}, 
		[37] = {critical_damage = 2,  args = {228}},
		[38] = {critical_damage = 2,  args = {218}},
		[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
		[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
		[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
		[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
		[51] = {critical_damage = 2,  args = {240}}, 
		[52] = {critical_damage = 2,  args = {238}},
		[53] = {critical_damage = 2,  args = {248}},
		[54] = {critical_damage = 2,  args = {247}},
		[56] = {critical_damage = 2,  args = {158}},
		[57] = {critical_damage = 2,  args = {157}},
		[59] = {critical_damage = 3,  args = {148}},
		[61] = {critical_damage = 2,  args = {147}},
		[82] = {critical_damage = 2,  args = {152}},
		},
		
		DamageParts = 
		{  
			[1] = "Su-47K-oblomok-wing-r", -- wing R
			[2] = "Su-47K-oblomok-wing-l", -- wing L
		},
}
add_aircraft(Su_47K)